import { Rect2 } from '@js-draw/math';
import AbstractRenderer from '../../rendering/renderers/AbstractRenderer';
import { StrokeDataPoint } from '../../types';
import Viewport from '../../Viewport';
import AbstractComponent from '../AbstractComponent';
import { ComponentBuilder, ComponentBuilderFactory } from './types';
/**
 * Creates a stroke builder that generates filled lines.
 *
 * Example:
 * [[include:doc-pages/inline-examples/changing-pen-types.md]]
 */
export declare const makeLineBuilder: ComponentBuilderFactory;
export default class LineBuilder implements ComponentBuilder {
    private readonly startPoint;
    private readonly viewport;
    private endPoint;
    constructor(startPoint: StrokeDataPoint, viewport: Viewport);
    getBBox(): Rect2;
    private buildPreview;
    build(): AbstractComponent;
    preview(renderer: AbstractRenderer): void;
    addPoint(point: StrokeDataPoint): void;
}
