//
// Stores objects loaded from an SVG that aren't recognised by the editor.
// @internal
// @packageDocumentation
//
import { Rect2 } from '@js-draw/math';
import  SVGRenderer  from '../rendering/renderers/SVGRenderer.mjs';
import  AbstractComponent, { ComponentSizingMode }  from './AbstractComponent.mjs';
const componentId = 'unknown-svg-object';
export default class UnknownSVGObject extends AbstractComponent {
    constructor(svgObject) {
        super(componentId);
        this.svgObject = svgObject;
        this.contentBBox = Rect2.of(svgObject.getBoundingClientRect());
    }
    render(canvas, _visibleRect) {
        if (!(canvas instanceof SVGRenderer)) {
            // Don't draw unrenderable objects if we can't
            return;
        }
        canvas.startObject(this.contentBBox);
        canvas.drawSVGElem(this.svgObject);
        canvas.endObject(this.getLoadSaveData());
    }
    intersects(lineSegment) {
        return this.contentBBox.getEdges().some((edge) => edge.intersection(lineSegment) !== null);
    }
    applyTransformation(_affineTransfm) { }
    isSelectable() {
        return false;
    }
    getSizingMode() {
        // This component can be shown anywhere (it won't be
        // visible to the user, it just needs to be saved with
        // the image).
        return ComponentSizingMode.Anywhere;
    }
    createClone() {
        return new UnknownSVGObject(this.svgObject.cloneNode(true));
    }
    description(localization) {
        return localization.svgObject;
    }
    serializeToJSON() {
        return JSON.stringify({
            html: this.svgObject.outerHTML,
        });
    }
}
// null: Do not deserialize UnknownSVGObjects.
AbstractComponent.registerComponent(componentId, null);
