import { Color4 } from '@js-draw/math';
import SerializableCommand from '../commands/SerializableCommand';
import Editor from '../Editor';
import TextRenderingStyle from '../rendering/TextRenderingStyle';
import AbstractComponent from './AbstractComponent';
export interface ComponentStyle {
    color?: Color4;
    textStyle?: TextRenderingStyle;
}
export declare const createRestyleComponentCommand: (initialStyle: ComponentStyle, newStyle: ComponentStyle, component: RestyleableComponent) => SerializableCommand;
export declare const isRestylableComponent: (component: AbstractComponent) => component is RestyleableComponent;
/**
 * An interface to be implemented by components with a changable color or {@link TextRenderingStyle}.
 *
 * All such classes must have a member variable, `isRestylableComponent` that is set to `true`
 * to allow testing whether the class is a `RestylableComponent` (see {@link isRestylableComponent}).
 */
export interface RestyleableComponent extends AbstractComponent {
    /**
     * @returns a partial representation of this component's style.
     */
    getStyle(): ComponentStyle;
    /**
     * Returns a {@link Command} that updates portions of this component's style
     * to the given `style`.
     *
     * @example
     * For some component and editor,
     * ```ts
     * editor.dispatch(component.updateStyle({ color: Color4.red }));
     * ```
     */
    updateStyle(style: ComponentStyle): SerializableCommand;
    /**
     * Set the style of this component in a way that can't be undone/redone
     * (does not create a command).
     *
     * Prefer `updateStyle(style).apply(editor)`.
     */
    forceStyle(style: ComponentStyle, editor: Editor | null): void;
    isRestylableComponent: true;
}
export default RestyleableComponent;
