import  SerializableCommand  from './SerializableCommand.mjs';
/**
 * A command that requires a component that may or may not be present in the editor when
 * the command is created.
 */
export default class UnresolvedSerializableCommand extends SerializableCommand {
    constructor(commandId, componentID, component) {
        super(commandId);
        this.component = component ?? null;
        this.componentID = componentID;
    }
    resolveComponent(image) {
        if (this.component) {
            return;
        }
        const component = image.lookupElement(this.componentID);
        if (!component) {
            throw new Error(`Unable to resolve component with ID ${this.componentID}`);
        }
        this.component = component;
    }
}
