import EditorImage from '../image/EditorImage';
import AbstractComponent from '../components/AbstractComponent';
import SerializableCommand from './SerializableCommand';
export type ResolveFromComponentCallback = () => SerializableCommand;
/**
 * A command that requires a component that may or may not be present in the editor when
 * the command is created.
 */
export default abstract class UnresolvedSerializableCommand extends SerializableCommand {
    protected component: AbstractComponent | null;
    protected readonly componentID: string;
    protected constructor(commandId: string, componentID: string, component?: AbstractComponent);
    protected resolveComponent(image: EditorImage): void;
}
