import Editor from '../Editor';
import Command from './Command';
export type DeserializationCallback = (data: Record<string, any> | any[], editor: Editor) => SerializableCommand;
/**
 * A command that can be serialized to or deserialized from JSON. To allow a command to be deserialized, {@link SerializableCommand.register}
 * must be called for each {@link SerializableCommand}.
 *
 * This is used to [allow collaborative editing](https://github.com/personalizedrefrigerator/js-draw/tree/main/docs/examples/example-collaborative).
 */
export default abstract class SerializableCommand extends Command {
    #private;
    /** @param commandTypeId - A unique identifier for this command. */
    constructor(commandTypeId: string);
    protected abstract serializeToJSON(): string | Record<string, any> | any[];
    private static deserializationCallbacks;
    serialize(): Record<string | symbol, any>;
    static deserialize(data: string | Record<string, any>, editor: Editor): SerializableCommand;
    static register(commandTypeId: string, deserialize: DeserializationCallback): void;
}
