/**
 * A `Command` is an action that can be done, redone, and undone. It's used to enable undo/redo.
 *
 * See {@link Editor.dispatch}.
 */
export class Command {
    // Called when the command is being deleted
    onDrop(_editor) { }
    /** @deprecated Use {@link uniteCommands} */
    static union(a, b) {
        return new (class extends Command {
            apply(editor) {
                a.apply(editor);
                b.apply(editor);
            }
            unapply(editor) {
                b.unapply(editor);
                a.unapply(editor);
            }
            description(editor, localizationTable) {
                const aDescription = a.description(editor, localizationTable);
                const bDescription = b.description(editor, localizationTable);
                if (aDescription === bDescription) {
                    return aDescription;
                }
                return `${aDescription}, ${bDescription}`;
            }
        })();
    }
}
Command.empty = new (class extends Command {
    description(_editor, _localizationTable) {
        return '';
    }
    apply(_editor) { }
    unapply(_editor) { }
})();
export default Command;
