import Editor from '../Editor';
import { EditorLocalization } from '../localization';
/**
 * A `Command` is an action that can be done, redone, and undone. It's used to enable undo/redo.
 *
 * See {@link Editor.dispatch}.
 */
export declare abstract class Command {
    abstract apply(editor: Editor): Promise<void> | void;
    abstract unapply(editor: Editor): Promise<void> | void;
    onDrop(_editor: Editor): void;
    abstract description(editor: Editor, localizationTable: EditorLocalization): string;
    /** @deprecated Use {@link uniteCommands} */
    static union(a: Command, b: Command): Command;
    static readonly empty: {
        description(_editor: Editor, _localizationTable: EditorLocalization): string;
        apply(_editor: Editor): void;
        unapply(_editor: Editor): void;
        onDrop(_editor: Editor): void;
    };
}
export default Command;
