type Options = {
    onStart: () => void;
    onEnd: () => void;
    longPressTimeout?: number;
};
/**
 * Calls `options.onStart` at the start of a long press or hover.
 * Calls `options.onEnd` when no pointers are within the container.
 */
declare const listenForLongPressOrHover: (target: HTMLElement, options: Options) => {
    removeListeners: () => void;
};
export default listenForLongPressOrHover;
