interface Callbacks {
    filter(event: KeyboardEvent): boolean;
    handleKeyDown(event: KeyboardEvent): void;
    handleKeyUp(event: KeyboardEvent): void;
    /**
     * Should return `true` iff `source` is also registered as an event listener source.
     * If `false` and focus leaves the original source, keyup events are fired.
     */
    getHandlesKeyEventsFrom(source: Node): boolean;
}
/**
 * Calls `callbacks` when different keys are known to be pressed.
 *
 * `filter` can be used to ignore events.
 *
 * This includes keys that didn't trigger a keydown or keyup event, but did cause
 * shiftKey/altKey/metaKey/etc. properties to change on other events (e.g. mousemove
 * events). Artifical events are created for these changes and sent to `callbacks`.
 */
declare const listenForKeyboardEventsFrom: (elem: HTMLElement, callbacks: Callbacks) => void;
export default listenForKeyboardEventsFrom;
