"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const createElement_1 = __importDefault(require("./createElement"));
const createButton = ({ onClick, text, classList = [] } = {}) => {
    const button = (0, createElement_1.default)('button', { type: 'button' });
    if (onClick) {
        button.onclick = onClick;
    }
    if (text) {
        button.textContent = text;
    }
    for (const className of classList) {
        button.classList.add(className);
    }
    return button;
};
exports.default = createButton;
