import { Editor } from '../Editor';
interface Callbacks {
    onPasteError(error: Error | unknown): void;
    onCopyError(error: Error | unknown): void;
}
/**
 * Handles conversion between the browser clipboard APIs and internal
 * js-draw clipboard events.
 */
export default class ClipboardHandler {
    #private;
    private editor;
    private callbacks?;
    constructor(editor: Editor, callbacks?: Callbacks | undefined);
    /**
     * Pastes data from the clipboard into the editor associated with
     * this handler.
     *
     * @param event Optional -- a clipboard/drag event. If not provided,
     * 				`navigator.clipboard` will be used instead.
     * @returns true if the paste event was handled by the editor.
     */
    paste(event?: DragEvent | ClipboardEvent): Promise<boolean>;
    private pasteInternal;
    /**
     * Copies text from the editor associated with this.
     *
     * Even if `event` is provided, the `navigator.clipboard` API may be used if image data
     * is to be copied. This is done because `ClipboardEvent`s seem to not support attaching
     * images.
     */
    copy(event?: ClipboardEvent | DragEvent): Promise<void>;
    private copyInternal;
}
export {};
