import Pointer from '../../Pointer';
interface Config {
    maxSpeed: number;
    minTimeSeconds: number;
    maxRadius: number;
}
export declare const defaultStationaryDetectionConfig: Config;
type OnStationaryCallback = (lastPointer: Pointer) => void;
export default class StationaryPenDetector {
    private config;
    private onStationary;
    private stationaryStartPointer;
    private lastPointer;
    private averageVelocity;
    private hasMovedOutOfRadius;
    private timeout;
    constructor(startPointer: Pointer, config: Config, onStationary: OnStationaryCallback);
    onPointerMove(currentPointer: Pointer): boolean | undefined;
    onPointerUp(pointer: Pointer): void;
    destroy(): void;
    getHasMovedOutOfRadius(): boolean;
    private cancelStationaryTimeout;
    private setStationaryTimeout;
}
export {};
