"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const BaseTool_1 = __importDefault(require("./BaseTool"));
const keybindings_1 = require("./keybindings");
// Handles ctrl+Z, ctrl+Shift+Z keyboard shortcuts.
class UndoRedoShortcut extends BaseTool_1.default {
    constructor(editor) {
        super(editor.notifier, editor.localization.undoRedoTool);
        this.editor = editor;
    }
    // @internal
    onKeyPress(event) {
        if (this.editor.shortcuts.matchesShortcut(keybindings_1.undoKeyboardShortcutId, event)) {
            void this.editor.history.undo();
            return true;
        }
        else if (this.editor.shortcuts.matchesShortcut(keybindings_1.redoKeyboardShortcutId, event)) {
            void this.editor.history.redo();
            return true;
        }
        return false;
    }
}
exports.default = UndoRedoShortcut;
