"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const BaseTool_1 = __importDefault(require("./BaseTool"));
/**
 * Handles keyboard events used, by default, to select tools. By default,
 * 1 maps to the first primary tool, 2 to the second primary tool, ... .
 *
 * This is in the default set of {@link ToolController} tools.
 *
 */
class ToolSwitcherShortcut extends BaseTool_1.default {
    constructor(editor) {
        super(editor.notifier, editor.localization.changeTool);
        this.editor = editor;
    }
    canReceiveInputInReadOnlyEditor() {
        return true;
    }
    // @internal
    onKeyPress({ key }) {
        const toolController = this.editor.toolController;
        const primaryTools = toolController.getPrimaryTools();
        // Map keys 0-9 to primary tools.
        const keyMatch = /^[0-9]$/.exec(key);
        let targetTool;
        if (keyMatch) {
            const targetIdx = parseInt(keyMatch[0], 10) - 1;
            targetTool = primaryTools[targetIdx];
        }
        if (targetTool) {
            targetTool.setEnabled(true);
            return true;
        }
        return false;
    }
}
exports.default = ToolSwitcherShortcut;
