import Editor from '../Editor';
import { KeyPressEvent, PointerEvt } from '../inputEvents';
import BaseTool from './BaseTool';
/**
 * This tool, when enabled, plays a sound representing the color of the portion of the display
 * currently under the cursor. This tool adds a button that can be navigated to with the tab key
 * that enables/disables the tool.
 *
 * This allows the user to explore the content of the display without a working screen.
 */
export default class SoundUITool extends BaseTool {
    private editor;
    private soundFeedback;
    private toggleButton;
    private toggleButtonContainer;
    constructor(editor: Editor, description: string);
    canReceiveInputInReadOnlyEditor(): boolean;
    private updateToggleButtonText;
    setEnabled(enabled: boolean): void;
    onKeyPress(event: KeyPressEvent): boolean;
    private lastPointerPos;
    onPointerDown({ current, allPointers }: PointerEvt): boolean;
    onPointerMove({ current }: PointerEvt): void;
    onPointerUp(_event: PointerEvt): void;
    onGestureCancel(): void;
}
