"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const createMenuOverlay_1 = __importDefault(require("../../util/createMenuOverlay"));
const ClipboardHandler_1 = __importDefault(require("../../../util/ClipboardHandler"));
const makeClipboardErrorHandlers_1 = __importDefault(require("./makeClipboardErrorHandlers"));
const showSelectionContextMenu = async (selectionBox, editor, canvasAnchor, preferSelectionMenu, clearSelection) => {
    const localization = editor.localization;
    const showSelectionMenu = selectionBox?.getSelectedItemCount() && preferSelectionMenu;
    const noSelectionMenu = [
        {
            text: localization.selectionMenu__paste,
            icon: () => editor.icons.makePasteIcon(),
            key: () => {
                const clipboardHandler = new ClipboardHandler_1.default(editor, (0, makeClipboardErrorHandlers_1.default)(editor));
                void clipboardHandler.paste();
            },
        },
    ];
    const onActivated = await (0, createMenuOverlay_1.default)(editor, canvasAnchor, showSelectionMenu
        ? [
            {
                text: localization.selectionMenu__duplicate,
                icon: () => editor.icons.makeDuplicateSelectionIcon(),
                key: async () => {
                    await editor.dispatch(await selectionBox.duplicateSelectedObjects());
                },
            },
            {
                text: localization.selectionMenu__delete,
                icon: () => editor.icons.makeDeleteSelectionIcon(),
                key: async () => {
                    await editor.dispatch(selectionBox.deleteSelectedObjects());
                    clearSelection();
                },
            },
            {
                text: localization.selectionMenu__copyToClipboard,
                icon: () => editor.icons.makeCopyIcon(),
                key: () => {
                    const clipboardHandler = new ClipboardHandler_1.default(editor, (0, makeClipboardErrorHandlers_1.default)(editor));
                    void clipboardHandler.copy();
                },
            },
            ...noSelectionMenu,
        ]
        : noSelectionMenu);
    onActivated?.();
};
exports.default = showSelectionContextMenu;
