"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const makeMessageDialog_1 = __importDefault(require("../../../dialogs/makeMessageDialog"));
const ClipboardHandler_1 = __importDefault(require("../../../util/ClipboardHandler"));
const makeClipboardErrorHandlers = (editor) => {
    const makeErrorDialog = (error) => {
        const dialog = (0, makeMessageDialog_1.default)(editor, {
            title: editor.localization.copyPasteError__heading,
            classNames: ['clipboard-error-dialog'],
        });
        dialog.appendChild(document.createTextNode(editor.localization.copyPasteError__description));
        const errorDetailsElement = document.createElement('details');
        const errorDetailsSummary = document.createElement('summary');
        errorDetailsSummary.textContent = editor.localization.copyPasteError__errorDetails;
        errorDetailsElement.appendChild(errorDetailsSummary);
        errorDetailsElement.appendChild(document.createTextNode(`Error: ${error}`));
        dialog.appendChild(errorDetailsElement);
        return dialog;
    };
    return {
        onCopyError(error) {
            const dialog = makeErrorDialog(error);
            const textboxLabel = document.createElement('label');
            textboxLabel.textContent = editor.localization.copyPasteError__copyRetry;
            const copyTextbox = document.createElement('textarea');
            textboxLabel.appendChild(copyTextbox);
            const retryHandler = new ClipboardHandler_1.default(editor);
            const handleCopy = (event) => {
                event.preventDefault();
                // Use .then to ensure that .copy runs within the event handler.
                // Copy can fail if certain logic is run async.
                return retryHandler.copy(event).then(() => {
                    dialog.close();
                });
            };
            copyTextbox.oncopy = handleCopy;
            copyTextbox.ondragstart = handleCopy;
            copyTextbox.value = editor.localization.copyPasteError__copyMe;
            dialog.appendChild(textboxLabel);
            copyTextbox.select();
            document.execCommand('copy');
        },
        onPasteError(error) {
            const dialog = makeErrorDialog(error);
            const textboxLabel = document.createElement('label');
            textboxLabel.textContent = editor.localization.copyPasteError__pasteRetry;
            const pasteTextbox = document.createElement('textarea');
            textboxLabel.appendChild(pasteTextbox);
            const retryHandler = new ClipboardHandler_1.default(editor);
            const handlePaste = (event) => {
                event.preventDefault();
                // Use .then to ensure that .paste runs within the event handler.
                // Paste can fail if certain logic is run async.
                return retryHandler.paste(event).then((pasted) => {
                    if (pasted) {
                        dialog.close();
                    }
                });
            };
            pasteTextbox.onpaste = handlePaste;
            pasteTextbox.ondrop = handlePaste;
            dialog.appendChild(textboxLabel);
            pasteTextbox.focus();
            document.execCommand('paste');
        },
    };
};
exports.default = makeClipboardErrorHandlers;
