import Editor from '../../Editor';
import { Vec3 } from '@js-draw/math';
import Selection from './Selection';
import { ResizeMode } from './types';
export declare class DragTransformer {
    private readonly editor;
    private selection;
    private dragStartPoint;
    constructor(editor: Editor, selection: Selection);
    onDragStart(startPoint: Vec3): void;
    onDragUpdate(canvasPos: Vec3): void;
    onDragEnd(): void | Promise<void>;
}
export declare class ResizeTransformer {
    private readonly editor;
    private selection;
    private mode;
    private dragStartPoint;
    private transformOrigin;
    private scaleRate;
    constructor(editor: Editor, selection: Selection);
    onDragStart(startPoint: Vec3, mode: ResizeMode): void;
    private computeOriginAndScaleRate;
    onDragUpdate(canvasPos: Vec3): void;
    onDragEnd(): void | Promise<void>;
}
export declare class RotateTransformer {
    private readonly editor;
    private selection;
    private startAngle;
    private targetRotation;
    private maximumDistFromStart;
    private startPoint;
    private startTime;
    constructor(editor: Editor, selection: Selection);
    private getAngle;
    private roundAngle;
    onDragStart(startPoint: Vec3): void;
    private setRotationTo;
    onDragUpdate(canvasPos: Vec3): void;
    onDragEnd(): void | Promise<void>;
}
