import AbstractComponent from '../../components/AbstractComponent';
import Editor from '../../Editor';
import { ContextMenuEvt, CopyEvent, KeyPressEvent, KeyUpEvent, PointerEvt } from '../../inputEvents';
import BaseTool from '../BaseTool';
import Selection from './Selection';
import { MutableReactiveValue } from '../../util/ReactiveValue';
import { SelectionMode } from './types';
export declare const cssPrefix = "selection-tool-";
export { SelectionMode };
export default class SelectionTool extends BaseTool {
    private editor;
    readonly modeValue: MutableReactiveValue<SelectionMode>;
    private selectionBuilder;
    private handleOverlay;
    private prevSelectionBox;
    private selectionBox;
    private removeSelectionScheduled;
    private startPoint;
    private expandingSelectionBox;
    private shiftKeyPressed;
    private snapToGrid;
    private lastPointer;
    private autoscroller;
    constructor(editor: Editor, description: string);
    private getSelectionColor;
    private makeSelectionBox;
    private showContextMenu;
    onContextMenu(event: ContextMenuEvt): boolean;
    private selectionBoxHandlingEvt;
    onPointerDown({ allPointers, current }: PointerEvt): boolean;
    onPointerMove(event: PointerEvt): void;
    private onMainPointerUpdated;
    onPointerUp(event: PointerEvt): void;
    onGestureCancel(): void;
    private lastSelectedObjects;
    private onSelectionUpdated;
    private zoomToSelection;
    private hasUnfinalizedTransformFromKeyPress;
    onKeyPress(event: KeyPressEvent): boolean;
    onKeyUp(evt: KeyUpEvent): boolean;
    onCopy(event: CopyEvent): boolean;
    setEnabled(enabled: boolean): void;
    getSelection(): Selection | null;
    /** @returns true if the selection is currently being created by the user. */
    isSelecting(): boolean;
    getSelectedObjects(): AbstractComponent[];
    setSelection(objects: AbstractComponent[]): void;
    private clearSelectionNoUpdateEvent;
    clearSelection(): void;
}
