import { Point2 } from '@js-draw/math';
import Selection from './Selection';
import Pointer from '../../Pointer';
import Viewport from '../../Viewport';
import { SelectionBoxChild } from './types';
import { ToolLocalization } from '../localization';
export type DragStartCallback = (startPoint: Point2) => void;
export type DragUpdateCallback = (canvasPoint: Point2) => void;
export type DragEndCallback = () => Promise<void> | void;
type OnShowContextMenu = (anchor: Point2) => void;
export default class SelectionMenuShortcut implements SelectionBoxChild {
    private readonly parent;
    private readonly viewport;
    private readonly icon;
    private localization;
    private element;
    private button;
    private onClick;
    constructor(parent: Selection, viewport: Viewport, icon: Element, showContextMenu: OnShowContextMenu, localization: ToolLocalization);
    private initUI;
    addTo(container: HTMLElement): void;
    remove(): void;
    private getElementScreenSize;
    /** Gets this menu's bounding box relative to the top left of its parent. */
    private getBBoxParentCoords;
    private getBBoxCanvasCoords;
    updatePosition(): void;
    containsPoint(canvasPoint: Point2): boolean;
    private lastDragPointer;
    handleDragStart(pointer: Pointer): boolean;
    handleDragUpdate(pointer: Pointer): void;
    handleDragEnd(): void;
}
export {};
