import { Point2, Vec2 } from '@js-draw/math';
import Selection from './Selection';
import Pointer from '../../Pointer';
import Viewport from '../../Viewport';
import { SelectionBoxChild } from './types';
export declare enum HandleAction {
    ResizeXY = "resize-xy",
    Rotate = "rotate",
    ResizeX = "resize-x",
    ResizeY = "resize-y"
}
export interface HandlePresentation {
    side: Vec2;
    icon?: Element;
    action: HandleAction;
}
export declare const handleSize = 30;
export type DragStartCallback = (startPoint: Point2) => void;
export type DragUpdateCallback = (canvasPoint: Point2) => void;
export type DragEndCallback = () => Promise<void> | void;
export default class SelectionHandle implements SelectionBoxChild {
    readonly presentation: HandlePresentation;
    private readonly parent;
    private readonly viewport;
    private readonly onDragStart;
    private readonly onDragUpdate;
    private readonly onDragEnd;
    private element;
    private snapToGrid;
    private shape;
    private parentSide;
    constructor(presentation: HandlePresentation, parent: Selection, viewport: Viewport, onDragStart: DragStartCallback, onDragUpdate: DragUpdateCallback, onDragEnd: DragEndCallback);
    /**
     * Adds this to `container`, where `conatiner` should be the background/selection
     * element visible on the screen.
     */
    addTo(container: HTMLElement): void;
    /**
     * Removes this element from its container. Should only be called
     * after {@link addTo}.
     */
    remove(): void;
    /**
     * Returns this handle's bounding box relative to the top left of the
     * selection box.
     */
    private getBBoxParentCoords;
    /** @returns this handle's bounding box relative to the canvas. */
    private getBBoxCanvasCoords;
    /**
     * Moves the HTML representation of this to the location matching its internal representation.
     */
    updatePosition(): void;
    /** @returns true iff `point` (in editor **canvas** coordinates) is in this. */
    containsPoint(point: Point2): boolean;
    private dragLastPos;
    handleDragStart(pointer: Pointer): boolean;
    handleDragUpdate(pointer: Pointer): void;
    handleDragEnd(): void | Promise<void>;
    setSnapToGrid(snap: boolean): void;
    isSnappingToGrid(): boolean;
}
