import { Color4, Path, Point2 } from '@js-draw/math';
import AbstractRenderer from '../../../rendering/renderers/AbstractRenderer';
import EditorImage from '../../../image/EditorImage';
import AbstractComponent from '../../../components/AbstractComponent';
import Viewport from '../../../Viewport';
export default abstract class SelectionBuilder {
    abstract onPointerMove(canvasPoint: Point2): void;
    abstract previewPath(): Path;
    /** Returns the components currently in the selection bounds. Used by {@link resolve}. */
    protected abstract resolveInternal(image: EditorImage): AbstractComponent[];
    /** Renders a preview of the selection bounds */
    render(renderer: AbstractRenderer, color: Color4): void;
    /** Converts the selection preview into a set of selected elements */
    resolve(image: EditorImage, viewport: Viewport): AbstractComponent[];
}
