"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const math_1 = require("@js-draw/math");
const SelectionBuilder_1 = __importDefault(require("./SelectionBuilder"));
/**
 * Creates rectangle selections
 */
class RectSelectionBuilder extends SelectionBuilder_1.default {
    constructor(startPoint) {
        super();
        this.rect = math_1.Rect2.fromCorners(startPoint, startPoint);
    }
    onPointerMove(canvasPoint) {
        this.rect = this.rect.grownToPoint(canvasPoint);
    }
    previewPath() {
        return math_1.Path.fromRect(this.rect);
    }
    resolveInternal(image) {
        return image.getComponentsIntersecting(this.rect).filter((element) => {
            // Filter out the case where the selection rectangle is completely contained
            // within the element (and does not intersect it).
            // This is useful, for example, if a very large stroke is used as the background
            // for another drawing. This prevents the very large stroke from being selected
            // unless the selection touches one of its edges.
            return element.intersectsRect(this.rect);
        });
    }
}
exports.default = RectSelectionBuilder;
