"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const BaseTool_1 = __importDefault(require("../BaseTool"));
const keybindings_1 = require("../keybindings");
const SelectionTool_1 = __importDefault(require("./SelectionTool"));
// Handles ctrl+a: Select all
class SelectAllShortcutHandler extends BaseTool_1.default {
    constructor(editor) {
        super(editor.notifier, editor.localization.selectAllTool);
        this.editor = editor;
    }
    canReceiveInputInReadOnlyEditor() {
        return true;
    }
    // @internal
    onKeyPress(event) {
        if (this.editor.shortcuts.matchesShortcut(keybindings_1.selectAllKeyboardShortcut, event)) {
            const selectionTools = this.editor.toolController.getMatchingTools(SelectionTool_1.default);
            if (selectionTools.length > 0) {
                const selectionTool = selectionTools[0];
                selectionTool.setEnabled(true);
                selectionTool.setSelection(this.editor.image.getAllComponents());
                return true;
            }
        }
        return false;
    }
}
exports.default = SelectAllShortcutHandler;
