import { Color4 } from '@js-draw/math';
import Editor from '../Editor';
import { PointerEvt } from '../inputEvents';
import BaseTool from './BaseTool';
type ColorListener = (color: Color4 | null) => void;
/**
 * A tool used internally to pick colors from the canvas.
 *
 * When color selection is in progress, the `pipette--color-selection-in-progress` class
 * is added to the root element. This can be used by themes.
 *
 * @internal
 */
export default class PipetteTool extends BaseTool {
    private editor;
    private colorPreviewListener;
    private colorSelectListener;
    constructor(editor: Editor, description: string);
    canReceiveInputInReadOnlyEditor(): boolean;
    private updateSelectingStatus;
    setColorListener(colorPreviewListener: ColorListener, colorSelectListener: ColorListener): void;
    clearColorListener(): void;
    onPointerDown({ current, allPointers }: PointerEvt): boolean;
    onPointerMove({ current }: PointerEvt): void;
    onPointerUp({ current }: PointerEvt): void;
    onGestureCancel(): void;
}
export {};
