import { Color4 } from '@js-draw/math';
import Editor from '../Editor';
import Pointer from '../Pointer';
import { StrokeDataPoint } from '../types';
import { KeyPressEvent, PointerEvt } from '../inputEvents';
import BaseTool from './BaseTool';
import { ComponentBuilder, ComponentBuilderFactory } from '../components/builders/types';
import { MutableReactiveValue } from '../util/ReactiveValue';
export interface PenStyle {
    readonly color: Color4;
    readonly thickness: number;
    readonly factory: ComponentBuilderFactory;
}
/**
 * A tool that allows drawing shapes and freehand lines.
 *
 * To change the type of shape drawn by the pen (e.g. to switch to the rectangle
 * pen type), see {@link setStrokeFactory}.
 */
export default class Pen extends BaseTool {
    private editor;
    protected builder: ComponentBuilder | null;
    private lastPoint;
    private startPoint;
    private currentDeviceType;
    private currentPointerId;
    private styleValue;
    private wetInkRenderer;
    private style;
    private shapeAutocompletionEnabled;
    private pressureSensitivityEnabled;
    private autocorrectedShape;
    private lastAutocorrectedShape;
    private removedAutocorrectedShapeTime;
    private stationaryDetector;
    constructor(editor: Editor, description: string, style: Partial<PenStyle>);
    private getPressureMultiplier;
    protected toStrokePoint(pointer: Pointer): StrokeDataPoint;
    protected previewStroke(): void;
    protected addPointToStroke(point: StrokeDataPoint): void;
    onPointerDown(event: PointerEvt): boolean;
    private eventCanCancelStroke;
    eventCanBeDeliveredToNonActiveTool(event: PointerEvt): boolean;
    onPointerMove({ current }: PointerEvt): void;
    onPointerUp({ current }: PointerEvt): boolean;
    private postGestureCleanup;
    onGestureCancel(): void;
    private removedAutocorrectedShapeRecently;
    private autocorrectShape;
    private finalizeStroke;
    private noteUpdated;
    setColor(color: Color4): void;
    setThickness(thickness: number): void;
    /**
     * Changes the type of stroke created by the pen. The given `factory` can be one of the built-in
     * stroke factories (e.g. {@link makeFreehandLineBuilder}) or a custom stroke factory.
     *
     * Example:
     * [[include:doc-pages/inline-examples/changing-pen-types.md]]
     */
    setStrokeFactory(factory: ComponentBuilderFactory): void;
    setHasStabilization(hasStabilization: boolean): void;
    setStrokeAutocorrectEnabled(enabled: boolean): void;
    getStrokeAutocorrectionEnabled(): boolean;
    setPressureSensitivityEnabled(enabled: boolean): void;
    getPressureSensitivityEnabled(): boolean;
    getThickness(): number;
    getColor(): Color4;
    getStrokeFactory(): ComponentBuilderFactory;
    getStyleValue(): MutableReactiveValue<PenStyle>;
    onKeyPress(event: KeyPressEvent): boolean;
}
