"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _InputPipeline_head, _InputPipeline_tail;
Object.defineProperty(exports, "__esModule", { value: true });
const InputMapper_1 = __importDefault(require("./InputMapper"));
/**
 * The composition of multiple `InputMapper`s.
 */
class InputPipeline extends InputMapper_1.default {
    constructor() {
        super(...arguments);
        _InputPipeline_head.set(this, null);
        _InputPipeline_tail.set(this, null);
    }
    onEvent(event) {
        if (__classPrivateFieldGet(this, _InputPipeline_head, "f") === null) {
            return this.emit(event);
        }
        else {
            return __classPrivateFieldGet(this, _InputPipeline_head, "f").onEvent(event);
        }
    }
    /**
     * Adds a new `InputMapper` to the *tail* of this pipeline.
     * Note that an instance of an `InputMapper` can only be used in a single
     * pipeline.
     */
    addToTail(mapper) {
        if (!__classPrivateFieldGet(this, _InputPipeline_tail, "f")) {
            __classPrivateFieldSet(this, _InputPipeline_head, mapper, "f");
            __classPrivateFieldSet(this, _InputPipeline_tail, __classPrivateFieldGet(this, _InputPipeline_head, "f"), "f");
        }
        else {
            __classPrivateFieldGet(this, _InputPipeline_tail, "f").setEmitListener(mapper);
            __classPrivateFieldSet(this, _InputPipeline_tail, mapper, "f");
        }
        __classPrivateFieldGet(this, _InputPipeline_tail, "f").setEmitListener((event) => this.emit(event));
    }
}
_InputPipeline_head = new WeakMap(), _InputPipeline_tail = new WeakMap();
exports.default = InputPipeline;
