import { InputEvt } from '../../inputEvents';
type OnEventCallback = (event: InputEvt) => boolean;
export interface InputEventListener {
    onEvent: OnEventCallback;
}
/**
 * Accepts input events and emits input events.
 */
export default abstract class InputMapper implements InputEventListener {
    #private;
    constructor();
    setEmitListener(listener: InputEventListener | OnEventCallback | null): void;
    protected emit(event: InputEvt): boolean;
    /**
     * @returns true if the given `event` should be considered "handled" by the app and thus not
     * forwarded to other targets. For example, returning "true" for a touchpad pinch event prevents
     * the pinch event from zooming the webpage.
     *
     * Generally, this should return the result of calling `this.emit` with some event.
     */
    abstract onEvent(event: InputEvt): boolean;
}
export {};
