"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const InputMapper_1 = __importDefault(require("./InputMapper"));
/**
 * An `InputMapper` that applies a function to all events it receives.
 *
 * Useful for automated testing.
 */
class FunctionMapper extends InputMapper_1.default {
    constructor(fn) {
        super();
        this.fn = fn;
    }
    onEvent(event) {
        return this.emit(this.fn(event));
    }
}
exports.default = FunctionMapper;
