"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const inputEvents_1 = require("../../inputEvents");
const InputMapper_1 = __importDefault(require("./InputMapper"));
const StationaryPenDetector_1 = __importStar(require("../util/StationaryPenDetector"));
const Pointer_1 = require("../../Pointer");
class ContextMenuRecognizer extends InputMapper_1.default {
    constructor() {
        super();
        this.canShowContextMenu = false;
        this.stationaryDetector = null;
        this.clickTolerance = 12;
    }
    /**
     * In general, only certain events (i.e. touchscreens) are expected to be able to
     * create long-press menus. This method checks whether `event` was generated by
     * one such device.
     */
    canMakeLongPressMenuEvent(event) {
        const allowedDevices = [Pointer_1.PointerDevice.Touch];
        return event.allPointers.length === 1 && allowedDevices.includes(event.current.device);
    }
    onEvent(event) {
        const sendContextMenuEvent = () => {
            if (!(0, inputEvents_1.isPointerEvt)(event))
                return false;
            if (this.canShowContextMenu) {
                const eventHandled = this.emit({
                    kind: inputEvents_1.InputEvtType.ContextMenu,
                    screenPos: event.current.screenPos,
                    canvasPos: event.current.canvasPos,
                });
                if (eventHandled) {
                    this.emit({
                        kind: inputEvents_1.InputEvtType.GestureCancelEvt,
                    });
                    return true;
                }
            }
            return false;
        };
        if (event.kind === inputEvents_1.InputEvtType.PointerDownEvt) {
            if (event.allPointers.length === 1) {
                this.canShowContextMenu = true;
                this.contextMenuTriggerPointer = event.current;
                this.contextMenuStartPoint = event.current.screenPos;
                if (this.canMakeLongPressMenuEvent(event)) {
                    this.stationaryDetector = new StationaryPenDetector_1.default(event.current, StationaryPenDetector_1.defaultStationaryDetectionConfig, sendContextMenuEvent);
                }
            }
            else {
                this.canShowContextMenu = false;
            }
        }
        else if (event.kind === inputEvents_1.InputEvtType.PointerMoveEvt) {
            if (this.canShowContextMenu) {
                this.stationaryDetector?.onPointerMove(event.current);
                // Only clicks/stationary long presses can create context menu events.
                const deltaPosition = event.current.screenPos.minus(this.contextMenuStartPoint);
                const threshold = this.clickTolerance;
                if (deltaPosition.length() > threshold) {
                    this.canShowContextMenu = false;
                }
            }
        }
        else if (event.kind === inputEvents_1.InputEvtType.PointerUpEvt) {
            this.stationaryDetector?.destroy();
            if (this.contextMenuTriggerPointer?.id === event.current.id &&
                this.contextMenuTriggerPointer.device === Pointer_1.PointerDevice.RightButtonMouse &&
                sendContextMenuEvent()) {
                return true;
            }
        }
        return this.emit(event);
    }
}
exports.default = ContextMenuRecognizer;
