import { GestureCancelEvt, KeyPressEvent, PointerEvt } from '../inputEvents';
import BaseTool from './BaseTool';
import Editor from '../Editor';
import { MutableReactiveValue } from '../util/ReactiveValue';
export declare enum EraserMode {
    PartialStroke = "partial-stroke",
    FullStroke = "full-stroke"
}
export interface InitialEraserOptions {
    thickness?: number;
    mode?: EraserMode;
}
/**
 * A tool that allows a user to erase parts of an image.
 */
export default class Eraser extends BaseTool {
    private editor;
    private lastPoint;
    private isFirstEraseEvt;
    private thickness;
    private thicknessValue;
    private modeValue;
    private toRemove;
    private toAdd;
    private eraseCommands;
    private addCommands;
    constructor(editor: Editor, description: string, options?: InitialEraserOptions);
    /**
     * @returns a tool that briefly enables the eraser when a physical eraser is used.
     * This tool should be added to the tool list after the primary tools.
     */
    makeEraserSwitcherTool(): BaseTool;
    private clearPreview;
    private getSizeOnCanvas;
    private drawPreviewAt;
    /**
     * @returns the eraser rectangle in canvas coordinates.
     *
     * For now, all erasers are rectangles or points.
     */
    private getEraserRect;
    /** Erases in a line from the last point to the current. */
    private eraseTo;
    onPointerDown(event: PointerEvt): boolean;
    onPointerMove(event: PointerEvt): void;
    onPointerUp(event: PointerEvt): void;
    onGestureCancel(_event: GestureCancelEvt): void;
    onKeyPress(event: KeyPressEvent): boolean;
    /** Returns the side-length of the tip of this eraser. */
    getThickness(): number;
    /** Sets the side-length of this' tip. */
    setThickness(thickness: number): void;
    /**
     * Returns a {@link MutableReactiveValue} that can be used to watch
     * this tool's thickness.
     */
    getThicknessValue(): MutableReactiveValue<number>;
    /** @returns An object that allows switching between a full stroke and a partial stroke eraser. */
    getModeValue(): MutableReactiveValue<EraserMode>;
}
