import { EditorNotifier } from '../types';
import { WheelEvt, PointerEvt, KeyPressEvent, KeyUpEvent, PasteEvent, CopyEvent, InputEvt, GestureCancelEvt, PointerDownEvt, PointerMoveEvt, PointerUpEvt, ContextMenuEvt } from '../inputEvents';
import ToolEnabledGroup from './ToolEnabledGroup';
import InputMapper, { InputEventListener } from './InputFilter/InputMapper';
import { ReactiveValue } from '../util/ReactiveValue';
export default abstract class BaseTool implements InputEventListener {
    #private;
    private notifier;
    readonly description: string;
    protected constructor(notifier: EditorNotifier, description: string);
    /** Override this to allow this tool to be enabled in a read-only editor */
    canReceiveInputInReadOnlyEditor(): boolean;
    setInputMapper(mapper: InputMapper | null): void;
    getInputMapper(): InputMapper | null;
    private dispatchEventToCallback;
    onEvent(event: InputEvt): boolean;
    /**
     * Returns true iff the tool handled the event and thus should receive additional
     * events.
     */
    onPointerDown(_event: PointerDownEvt): boolean;
    onPointerMove(_event: PointerMoveEvt): void;
    /**
     * Returns true iff there are additional pointers down and the tool should
     * remain active to handle the additional events.
     *
     * For most purposes, this should return `false` or nothing.
     */
    onPointerUp(_event: PointerUpEvt): boolean | void;
    onGestureCancel(_event: GestureCancelEvt): void;
    onWheel(_event: WheelEvt): boolean;
    onCopy(_event: CopyEvent): boolean;
    onPaste(_event: PasteEvent): boolean;
    onKeyPress(_event: KeyPressEvent): boolean;
    onKeyUp(_event: KeyUpEvent): boolean;
    onContextMenu(_event: ContextMenuEvt): boolean;
    /**
     * Return true if, while this tool is active, `_event` can be delivered to
     * another tool that is higher priority than this.
     * @internal May be renamed
     */
    eventCanBeDeliveredToNonActiveTool(_event: PointerEvt): boolean;
    setEnabled(enabled: boolean): void;
    isEnabled(): boolean;
    /**
     * Returns a {@link ReactiveValue} that updates based on whether this tool is
     * enabled.
     *
     * @example
     * ```ts
     * const tool = new SomeTool();
     *
     * // Watch for changes in enabled status
     * tool.enabledValue().onUpdate(enabled => doSomething(enabled));
     * ```
     */
    enabledValue(): ReactiveValue<boolean>;
    setToolGroup(group: ToolEnabledGroup): void;
    getToolGroup(): ToolEnabledGroup | null;
    onDestroy(): void;
}
