"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ReactiveValue_1 = require("../../../util/ReactiveValue");
class EdgeToolbarLayoutManager {
    // @internal
    constructor(setSidebarContent, sidebarTitle, sidebarVisibility, announceForAccessibility, localization) {
        this.setSidebarContent = setSidebarContent;
        this.sidebarTitle = sidebarTitle;
        this.sidebarVisibility = sidebarVisibility;
        this.announceForAccessibility = announceForAccessibility;
        this.localization = localization;
        this.visibleWidgetContent = ReactiveValue_1.ReactiveValue.fromInitialValue(null);
    }
    /** Creates a dropdown within `parent`. */
    createToolMenu(parent) {
        const contentElem = document.createElement('div');
        let result = null;
        const visible = ReactiveValue_1.ReactiveValue.fromCallback(() => {
            return this.visibleWidgetContent.get() === result && this.sidebarVisibility.get();
        }, [this.visibleWidgetContent, this.sidebarVisibility]);
        result = {
            visible,
            requestShow: () => {
                this.setSidebarContent(contentElem);
                this.sidebarTitle.set(parent.getTitle());
                // Set visibleWidgetContent first -- this causes the previously visible (if any)
                // item to not be sent a shown event.
                this.visibleWidgetContent.set(result);
                this.sidebarVisibility.set(true);
                this.announceForAccessibility(this.localization.dropdownShown(parent.getTitle()));
            },
            onActivated: () => {
                // TODO: Only request show when in sidebar mode
                //result?.requestShow();
            },
            requestHide: () => {
                if (visible.get()) {
                    this.sidebarVisibility.set(false);
                }
            },
            appendChild: (item) => {
                contentElem.appendChild(item);
            },
            clearChildren: () => {
                contentElem.replaceChildren();
            },
            destroy: () => {
                result?.requestHide();
                if (contentElem.parentElement) {
                    contentElem.remove();
                }
                if (this.visibleWidgetContent.get() === result) {
                    this.visibleWidgetContent.set(null);
                }
            },
        };
        return result;
    }
}
exports.default = EdgeToolbarLayoutManager;
