import { EditorNotifier } from '../../../types';
import { ToolbarLocalization } from '../../localization';
import { ToolMenu, WidgetContentLayoutManager, ToolMenuParent } from './types';
export default class DropdownLayoutManager implements WidgetContentLayoutManager {
    private localization;
    private notifier;
    private dropdowns;
    constructor(announceForAccessibility: (text: string) => void, localization: ToolbarLocalization);
    private listeners;
    private connectedNotifiers;
    connectToEditorNotifier(notifier: EditorNotifier): void;
    /** Creates a dropdown within `parent`. */
    createToolMenu(parent: ToolMenuParent): ToolMenu;
    /**
     * Adds/removes listeners based on whether we have any managed dropdowns.
     *
     * We attempt to clean up all resources when `dropdowns.size == 0`, at which
     * point, an instance of this could be safely garbage collected.
     */
    private refreshListeners;
}
