"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const math_1 = require("@js-draw/math");
const constants_1 = require("../../constants");
let idCounter = 0;
const makeThicknessSlider = (context, onChange) => {
    const container = document.createElement('div');
    const thicknessLabel = document.createElement('label');
    const thicknessInput = document.createElement('input');
    container.classList.add(`${constants_1.toolbarCSSPrefix}thicknessSliderContainer`);
    // Give inputs IDs so we can label them with a <label for=...>Label text</label>
    thicknessInput.id = `${constants_1.toolbarCSSPrefix}thicknessInput${idCounter++}`;
    thicknessLabel.innerText = context.localization.thicknessLabel;
    thicknessLabel.setAttribute('for', thicknessInput.id);
    // Use a logarithmic scale for thicknessInput (finer control over thinner strokewidths.)
    const inverseThicknessInputFn = (t) => Math.log10(t);
    const thicknessInputFn = (t) => 10 ** t;
    thicknessInput.type = 'range';
    thicknessInput.oninput = () => {
        onChange(thicknessInputFn(parseFloat(thicknessInput.value)));
    };
    container.appendChild(thicknessLabel);
    container.appendChild(thicknessInput);
    const setBounds = (min, max) => {
        const round = (value, roundUp) => {
            const roundFn = roundUp ? Math.ceil : Math.floor;
            return roundFn(value * 100) / 100;
        };
        const sliderMin = round(inverseThicknessInputFn(min), false);
        const sliderMax = round(inverseThicknessInputFn(max), true);
        thicknessInput.min = `${sliderMin}`;
        thicknessInput.max = `${sliderMax}`;
        thicknessInput.step = `${(0, math_1.toRoundedString)((sliderMax - sliderMin) / 20)}`;
    };
    setBounds(2, 262);
    return {
        container,
        addTo: (parent) => {
            parent.appendChild(container);
        },
        setBounds,
        setValue: (thickness) => {
            thicknessInput.value = inverseThicknessInputFn(thickness).toString();
        },
    };
};
exports.default = makeThicknessSlider;
