import { MutableReactiveValue } from '../../../util/ReactiveValue';
import { IconElemType } from '../../IconProvider';
interface GridSelectChoice<ChoiceIdType> {
    id: ChoiceIdType;
    makeIcon: () => IconElemType;
    title: string;
}
interface GridSelector<ChoiceIdType> {
    value: MutableReactiveValue<ChoiceIdType>;
    /**
     * Connects this grid selector with `other` such that only one item in
     * either this or `other` can be selected at a time.
     */
    linkWith: (other: GridSelector<ChoiceIdType>) => void;
    /** Re-builds the icons shown in the grid selector. */
    updateIcons: () => void;
    getRootElement: () => HTMLElement;
    addTo: (parent: HTMLElement) => void;
    /** Used internally @internal */
    _radiogroupName: string;
}
/**
 * Creates a widget that allows users to select one of serveral items from a list.
 *
 * `ChoiceIdType` should be `string`, a `number`, or an `enum` (or similar).
 *
 * If this input is set to an ID that is not in `choices`, no item is selected.
 */
declare const makeGridSelector: <ChoiceIdType>(labelText: string, defaultId: ChoiceIdType, choices: GridSelectChoice<ChoiceIdType>[]) => GridSelector<ChoiceIdType>;
export default makeGridSelector;
