"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const addLongPressOrHoverCssClasses_1 = __importDefault(require("../../../util/dom/addLongPressOrHoverCssClasses"));
const createButton_1 = __importDefault(require("../../../util/dom/createButton"));
/**
 * Creates HTML `button` elements from `buttonSpecs` and displays them in a
 * grid with `columnCount` columns.
 */
const makeButtonGrid = (buttonSpecs, columnCount) => {
    const container = document.createElement('div');
    container.classList.add('toolbar-button-grid');
    container.style.setProperty('--column-count', `${columnCount}`);
    const makeButton = (buttonSpec) => {
        const buttonElement = (0, createButton_1.default)();
        buttonElement.classList.add('button');
        const iconElement = buttonSpec.icon();
        iconElement.classList.add('icon');
        const labelElement = document.createElement('label');
        labelElement.textContent = buttonSpec.label;
        labelElement.classList.add('button-label-text');
        buttonElement.onclick = buttonSpec.onClick;
        if (buttonSpec.enabled) {
            buttonSpec.enabled.onUpdateAndNow((enabled) => {
                buttonElement.disabled = !enabled;
            });
        }
        buttonElement.replaceChildren(iconElement, labelElement);
        container.appendChild(buttonElement);
        (0, addLongPressOrHoverCssClasses_1.default)(buttonElement);
        buttonSpec.onCreated?.(buttonElement);
        return buttonElement;
    };
    buttonSpecs.map(makeButton);
    return {
        container,
    };
};
exports.default = makeButtonGrid;
