import { ReactiveValue } from '../../../util/ReactiveValue';
import { IconElemType } from '../../IconProvider';
interface Button {
    icon: () => IconElemType;
    label: string;
    onClick: () => void;
    onCreated?: (button: HTMLElement) => void;
    enabled?: ReactiveValue<boolean>;
}
/**
 * Creates HTML `button` elements from `buttonSpecs` and displays them in a
 * grid with `columnCount` columns.
 */
declare const makeButtonGrid: (buttonSpecs: Button[], columnCount: number) => {
    container: HTMLDivElement;
};
export default makeButtonGrid;
