import { ComponentBuilderFactory } from '../../components/builders/types';
import Editor from '../../Editor';
import Pen from '../../tools/Pen';
import { KeyPressEvent } from '../../inputEvents';
import { ToolbarLocalization } from '../localization';
import BaseToolWidget from './BaseToolWidget';
import { SavedToolbuttonState } from './BaseWidget';
import HelpDisplay from '../utils/HelpDisplay';
/** Represents a style that can be applied to a pen tool. */
export interface PenTypeRecord {
    name: string;
    id: string;
    isShapeBuilder?: boolean;
    factory: ComponentBuilderFactory;
}
/**
 * This toolbar widget allows a user to control a single {@link Pen} tool.
 *
 * See also {@link AbstractToolbar.addDefaultToolWidgets}.
 */
export default class PenToolWidget extends BaseToolWidget {
    private tool;
    private updateInputs;
    protected penTypes: Readonly<PenTypeRecord>[];
    protected shapelikeIDs: string[];
    private static idCounter;
    constructor(editor: Editor, tool: Pen, localization?: ToolbarLocalization);
    protected getTitle(): string;
    private getCurrentPenTypeIdx;
    private getCurrentPenType;
    private createIconForRecord;
    protected createIcon(): Element;
    private createPenTypeSelector;
    protected createStrokeCorrectionOptions(helpOverlay?: HelpDisplay): {
        update: () => void;
        addTo: (parent: HTMLElement) => void;
    };
    protected getHelpText(): string;
    protected fillDropdown(dropdown: HTMLElement, helpDisplay?: HelpDisplay): boolean;
    protected onKeyPress(event: KeyPressEvent): boolean;
    serializeState(): SavedToolbuttonState;
    deserializeFrom(state: SavedToolbuttonState): void;
}
