"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fileToBase64Url_1 = __importDefault(require("../../../util/fileToBase64Url"));
const math_1 = require("@js-draw/math");
const fileToImages = async (imageFile) => {
    const result = [];
    const imageElement = new Image();
    const base64Url = await (0, fileToBase64Url_1.default)(imageFile);
    if (base64Url) {
        result.push({
            image: imageElement,
            base64Url: base64Url,
            transform: math_1.Mat33.identity,
        });
    }
    return result;
};
exports.default = fileToImages;
