import Editor from '../../../Editor';
import { ToolbarLocalization } from '../../localization';
import BaseWidget from '../BaseWidget';
/**
 * Provides a widget that allows inserting or modifying raster images.
 *
 * It's possible to customize the file picker used by this widget through {@link EditorSettings.image}.
 *
 * @example
 * ```ts,runnable
 * import { Editor, makeEdgeToolbar, InsertImageWidget } from 'js-draw';
 *
 * const editor = new Editor(document.body);
 * const toolbar = makeEdgeToolbar(editor);
 *
 * toolbar.addWidget(new InsertImageWidget(editor));
 * ```
 */
export default class InsertImageWidget extends BaseWidget {
    private images;
    private imagesPreview;
    private selectedFiles;
    private imageAltTextInput;
    private statusView;
    private submitButton;
    constructor(editor: Editor, localization?: ToolbarLocalization);
    protected getTitle(): string;
    protected createIcon(): Element | null;
    protected setDropdownVisible(visible: boolean): void;
    protected handleClick(): void;
    private static nextInputId;
    protected fillDropdown(dropdown: HTMLElement): boolean;
    private onImageDataUpdate;
    private hideDialog;
    private updateImageSizeDisplay;
    private updateInputs;
}
