"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ActionButtonWidget_1 = __importDefault(require("./ActionButtonWidget"));
const BaseWidget_1 = require("./BaseWidget");
const keybindings_1 = require("./keybindings");
class ExitActionWidget extends ActionButtonWidget_1.default {
    constructor(editor, localization, saveCallback, labelOverride = {}) {
        super(editor, 'exit-button', 
        // Creates an icon
        () => {
            return labelOverride.icon ?? editor.icons.makeCloseIcon();
        }, labelOverride.label ?? localization.exit, saveCallback);
        this.setTags([BaseWidget_1.ToolbarWidgetTag.Exit]);
    }
    shouldAutoDisableInReadOnlyEditor() {
        return false;
    }
    onKeyPress(event) {
        if (this.editor.shortcuts.matchesShortcut(keybindings_1.exitKeyboardShortcut, event)) {
            this.clickAction();
            return true;
        }
        return super.onKeyPress(event);
    }
    mustBeInToplevelMenu() {
        return true;
    }
}
exports.default = ExitActionWidget;
