import Editor from '../../Editor';
import { ToolbarLocalization } from '../localization';
import BaseWidget from './BaseWidget';
export default class ActionButtonWidget extends BaseWidget {
    #private;
    protected makeIcon: () => Element | null;
    protected title: string;
    protected clickAction: () => void;
    protected mustBeToplevel: boolean;
    constructor(editor: Editor, id: string, makeIcon: () => Element | null, title: string, clickAction: () => void, localizationTable?: ToolbarLocalization, mustBeToplevel?: boolean, autoDisableInReadOnlyEditors?: boolean);
    /**
     * Sets the text shown in a help overlay for this button.
     *
     * See {@link getHelpText}.
     */
    setHelpText(helpText: string): void;
    protected getHelpText(): string | undefined;
    protected shouldAutoDisableInReadOnlyEditor(): boolean;
    protected handleClick(): void;
    protected getTitle(): string;
    protected createIcon(): Element | null;
    protected fillDropdown(_dropdown: HTMLElement): boolean;
    mustBeInToplevelMenu(): boolean;
}
