import Editor from '../Editor';
import { ToolbarLocalization } from './localization';
import BaseWidget from './widgets/BaseWidget';
import AbstractToolbar, { SpacerOptions } from './AbstractToolbar';
/**
 * Creates an `EdgeToolbar`.
 *
 * [Credit for the original design of this UI](https://www.figma.com/file/NA5F2AMWO3wUuaoDfUaAb8/Material-3-wireframes?type=design&node-id=54490%3A1103&mode=design&t=Ee0UwnPnQ2bNC2uM-1).
 *
 * @example
 *
 * ```ts,runnable
 * import { makeEdgeToolbar, Editor } from 'js-draw';
 *
 * const editor = new Editor(document.body);
 * const toolbar = makeEdgeToolbar(editor);
 * toolbar.addDefaults();
 *
 * toolbar.addSaveButton(editor => {
 *   // TODO
 * });
 *
 * toolbar.addExitButton(editor => {
 *   // TODO
 * });
 * ```
 *
 * @see
 * - {@link makeDropdownToolbar}
 * - {@link AbstractToolbar.addSaveButton}
 * - {@link AbstractToolbar.addExitButton}
 */
export declare const makeEdgeToolbar: (editor: Editor) => AbstractToolbar;
export default class EdgeToolbar extends AbstractToolbar {
    private toolbarContainer;
    private toolbarActionRow;
    private toolbarToolRow;
    private toolRowResizeObserver;
    private menuContainer;
    private sidebarContainer;
    private sidebarContent;
    private closeButton;
    private layoutManager;
    private sidebarVisible;
    private sidebarY;
    private sidebarTitle;
    private clearDragListeners;
    /** @internal */
    constructor(editor: Editor, parent: HTMLElement, localizationTable: ToolbarLocalization);
    private listenForVisibilityChanges;
    private onToolbarRowResize;
    addSpacer(_options?: Partial<SpacerOptions>): void;
    addUndoRedoButtons(): void;
    addDefaults(): void;
    private updateWidgetCSSClasses;
    protected addWidgetInternal(widget: BaseWidget): void;
    protected removeWidgetInternal(widget: BaseWidget): void;
    protected onRemove(): void;
    private initDragListeners;
    /**
     * Updates the position of this menu **during** a drag. After a drag ends,
     * {@link finalizeDrag} should be called.
     */
    private handleDrag;
    /** Returns `this.sidebarY` rounded to a valid value. */
    private snappedSidebarY;
    /**
     * Moves the menu to a valid location or closes it, depending on
     * the position set by the drag.
     */
    private finalizeDrag;
    protected serializeInternal(): {
        menuSizeY: number;
    };
    protected deserializeInternal(json: any): void;
}
