"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const math_1 = require("@js-draw/math");
const sendTouchEvent_1 = __importDefault(require("./sendTouchEvent"));
const inputEvents_1 = require("../inputEvents");
/**
 * Creates two pointers and sends the touch {@link InputEvtType.PointerDownEvt}s for them.
 *
 * Returns an object that allows continuing or ending the gesture.
 *
 * `initialRotation` should be in radians.
 */
const startPinchGesture = (editor, center, initialDistance, initialRotation) => {
    const computeTouchPoints = (center, distance, rotation) => {
        const halfDisplacement = math_1.Mat33.zRotation(rotation).transformVec2(math_1.Vec2.of(0, distance / 2));
        const point1 = center.plus(halfDisplacement);
        const point2 = center.minus(halfDisplacement);
        return [point1, point2];
    };
    let [touchPoint1, touchPoint2] = computeTouchPoints(center, initialDistance, initialRotation);
    let firstPointer = (0, sendTouchEvent_1.default)(editor, inputEvents_1.InputEvtType.PointerDownEvt, touchPoint1);
    let secondPointer = (0, sendTouchEvent_1.default)(editor, inputEvents_1.InputEvtType.PointerDownEvt, touchPoint2, [
        firstPointer,
    ]);
    return {
        update(center, distance, rotation) {
            const eventType = inputEvents_1.InputEvtType.PointerMoveEvt;
            const [newPoint1, newPoint2] = computeTouchPoints(center, distance, rotation);
            touchPoint1 = newPoint1;
            touchPoint2 = newPoint2;
            firstPointer = (0, sendTouchEvent_1.default)(editor, eventType, newPoint1, [secondPointer]);
            secondPointer = (0, sendTouchEvent_1.default)(editor, eventType, newPoint2, [firstPointer]);
        },
        end() {
            (0, sendTouchEvent_1.default)(editor, inputEvents_1.InputEvtType.PointerUpEvt, touchPoint1, [secondPointer]);
            (0, sendTouchEvent_1.default)(editor, inputEvents_1.InputEvtType.PointerUpEvt, touchPoint2);
        },
    };
};
exports.default = startPinchGesture;
