import type Editor from '../Editor';
import { Point2 } from '@js-draw/math';
/**
 * Creates two pointers and sends the touch {@link InputEvtType.PointerDownEvt}s for them.
 *
 * Returns an object that allows continuing or ending the gesture.
 *
 * `initialRotation` should be in radians.
 */
declare const startPinchGesture: (editor: Editor, center: Point2, initialDistance: number, initialRotation: number) => {
    update(center: Point2, distance: number, rotation: number): void;
    end(): void;
};
export default startPinchGesture;
