"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Pointer_1 = __importStar(require("../Pointer"));
const inputEvents_1 = require("../inputEvents");
const getUniquePointerId_1 = __importDefault(require("./getUniquePointerId"));
/**
 * Dispatch a touch event to the currently selected tool. Intended for unit tests.
 *
 * @see {@link sendPenEvent}
 *
 * @example
 * **Simulating a horizontal swipe gesture:**
 * ```ts
 * sendTouchEvent(editor, InputEvtType.PointerDownEvt, Vec2.of(0, 0));
 * for (let i = 1; i <= 10; i++) {
 *   jest.advanceTimersByTime(10);
 *   sendTouchEvent(editor, InputEvtType.PointerMoveEvt, Vec2.of(i * 10, 0));
 * }
 * ```
 *
 * @example
 * **Simulating a pinch gesture.** This example assumes that you're using [Jest with timer mocks enabled](https://jestjs.io/docs/timer-mocks).
 * ```ts
 * let firstPointer = sendTouchEvent(editor, InputEvtType.PointerDownEvt, Vec2.of(0, 0));
 * let secondPointer = sendTouchEvent(editor, InputEvtType.PointerDownEvt, Vec2.of(100, 0), [ firstPointer ]);
 *
 * // Simulate a pinch
 * const maxIterations = 10;
 * for (let i = 0; i < maxIterations; i++) {
 *   // Use the unit testing framework's tool for increasing the current time
 *   // returned by (new Date()).getTime(), etc.
 *   jest.advanceTimersByTime(100);
 *
 *   const point1 = Vec2.of(-i * 5, 0);
 *   const point2 = Vec2.of(i * 5 + 100, 0);
 *
 *   firstPointer = sendTouchEvent(editor, InputEvtType.PointerMoveEvt, point1, [ secondPointer ]);
 *   secondPointer = sendTouchEvent(editor, InputEvtType.PointerMoveEvt, point2, [ firstPointer ]);
 * }
 * ```
 */
const sendTouchEvent = (editor, eventType, screenPos, allOtherPointers) => {
    const canvasPos = editor.viewport.screenToCanvas(screenPos);
    // Get a unique ID for the main pointer
    // (try to use id=0, but don't use it if it's already in use).
    const ptrId = (0, getUniquePointerId_1.default)(allOtherPointers ?? []);
    const mainPointer = Pointer_1.default.ofCanvasPoint(canvasPos, eventType !== inputEvents_1.InputEvtType.PointerUpEvt, editor.viewport, ptrId, Pointer_1.PointerDevice.Touch);
    editor.toolController.dispatchInputEvent({
        kind: eventType,
        allPointers: [...(allOtherPointers ?? []), mainPointer],
        current: mainPointer,
    });
    return mainPointer;
};
exports.default = sendTouchEvent;
