"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Editor_1 = __importDefault(require("../Editor"));
const inputEvents_1 = require("../inputEvents");
const guessKeyCodeFromKey_1 = __importDefault(require("../util/guessKeyCodeFromKey"));
const sendKeyPressRelease = (target, key) => {
    if (target instanceof Editor_1.default) {
        target.sendKeyboardEvent(inputEvents_1.InputEvtType.KeyPressEvent, key);
        target.sendKeyboardEvent(inputEvents_1.InputEvtType.KeyUpEvent, key);
    }
    else {
        const code = (0, guessKeyCodeFromKey_1.default)(key);
        target.dispatchEvent(new KeyboardEvent('keydown', { key, code }));
        target.dispatchEvent(new KeyboardEvent('keyup', { key, code }));
    }
};
exports.default = sendKeyPressRelease;
