"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** Returns the first ancestor of the given node (or the node itself) that is an HTMLElement */
const firstElementAncestorOfNode = (node) => {
    if (node instanceof HTMLElement) {
        return node;
    }
    else if (node?.parentNode) {
        return firstElementAncestorOfNode(node.parentNode);
    }
    return null;
};
exports.default = firstElementAncestorOfNode;
